<?php
use yii\db\Migration;

class m251026_191956_create_users_table extends Migration
{
    public function up()
    {
        $this->createTable('users', [
            'id' => $this->primaryKey(),
            'username' => $this->string(50)->notNull()->unique(),
            'email' => $this->string(100)->notNull()->unique(),
            'password_hash' => $this->string(255)->notNull(),
            'full_name' => $this->string(150)->notNull(),
            'passport_series' => $this->string(4)->notNull(),
            'passport_number' => $this->string(6)->notNull(),
            'address' => $this->text()->notNull(),
            'phone' => $this->string(20)->notNull(),
            'auth_key' => $this->string(32),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

        $this->insert('users', [
            'username' => 'hotel',
            'email' => 'admin@hotel.local',
            'password_hash' => Yii::$app->security->generatePasswordHash('hoteladmin'),
            'full_name' => 'Администратор Отеля',
            'passport_series' => '0000',
            'passport_number' => '000000',
            'address' => 'Администрация отеля',
            'phone' => '+7(000)-000-00-00',
            'auth_key' => Yii::$app->security->generateRandomString(),
        ]);
    }

    public function down()
    {
        $this->dropTable('users');
    }
}