<?php
// models/RoomType.php
namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class RoomType extends ActiveRecord
{
    public static function tableName()
    {
        return 'room_types';
    }

    public function rules()
    {
        return [
            [['name', 'price_per_night', 'max_guests'], 'required'],
            [['description'], 'string'],
            [['price_per_night'], 'number'],
            [['max_guests'], 'integer'],
            [['name', 'bed_type'], 'string', 'max' => 255],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название',
            'description' => 'Описание',
            'price_per_night' => 'Цена за ночь',
            'max_guests' => 'Максимум гостей',
            'bed_type' => 'Тип кровати',
            'created_at' => 'Создан',
        ];
    }

    public function getBookings()
    {
        return $this->hasMany(Booking::class, ['room_type_id' => 'id']);
    }
}