<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Управление заявками';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-bookings">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
    </div>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            [
                'attribute' => 'user.full_name',
                'label' => 'Пользователь',
            ],
            [
                'attribute' => 'roomType.name',
                'label' => 'Тип номера',
            ],
            [
                'attribute' => 'check_in_date',
                'format' => 'date',
            ],
            [
                'attribute' => 'check_out_date',
                'format' => 'date',
            ],
            [
                'attribute' => 'total_amount',
                'format' => 'currency',
            ],
            [
                'attribute' => 'status',
                'content' => function($model) {
                    $statusColors = [
                        'new' => 'primary',
                        'in_process' => 'warning',
                        'completed' => 'success',
                        'cancelled' => 'danger',
                    ];
                    return '<span class="badge bg-' . ($statusColors[$model->status] ?? 'secondary') . '">' .
                        $model->getStatusLabel() . '</span>';
                },
                'format' => 'raw',
            ],
            [
                'attribute' => 'created_at',
                'format' => 'datetime',
            ],
            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{view} {update}',
                'buttons' => [
                    'view' => function ($url, $model) {
                        return Html::a('<i class="fas fa-eye"></i>', $url, [
                            'class' => 'btn btn-sm btn-outline-primary',
                            'title' => 'Просмотр',
                        ]);
                    },
                    'update' => function ($url, $model) {
                        return Html::a('<i class="fas fa-edit"></i>', $url, [
                            'class' => 'btn btn-sm btn-outline-secondary',
                            'title' => 'Редактировать',
                        ]);
                    },
                ],
            ],
        ],
    ]); ?>
</div>