<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-index">
    <div class="row">
        <div class="col-12">
            <h1 class="mb-4"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 mb-3">
            <div class="card bg-primary text-white">
                <div class="card-body text-center">
                    <h4><?= $bookingsCount ?></h4>
                    <p>Всего заявок</p>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-success text-white">
                <div class="card-body text-center">
                    <h4><?= $usersCount ?></h4>
                    <p>Пользователей</p>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-info text-white">
                <div class="card-body text-center">
                    <h4><?= $reviewsCount ?></h4>
                    <p>Отзывов</p>
                </div>
            </div>
        </div>
        <div class="col-md-3 mb-3">
            <div class="card bg-warning text-white">
                <div class="card-body text-center">
                    <h4><?= $newBookings ?></h4>
                    <p>Новых заявок</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-3 mb-3">
            <a href="<?= Url::to(['admin/bookings']) ?>" class="btn btn-primary w-100 p-3">
                Управление заявками
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="<?= Url::to(['admin/users']) ?>" class="btn btn-success w-100 p-3">
                Пользователи
            </a>
        </div>
        <div class="col-md-3 mb-3">
            <a href="<?= Url::to(['admin/room-types']) ?>" class="btn btn-warning w-100 p-3">
                Типы номеров
            </a>
        </div>
    </div>
</div>