<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Отзывы';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-reviews">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
    </div>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            [
                'attribute' => 'user.full_name',
                'label' => 'Пользователь',
            ],
            [
                'attribute' => 'booking_id',
                'label' => 'Бронирование',
            ],
            'rating',
            [
                'attribute' => 'comment',
                'format' => 'ntext',
                'contentOptions' => ['style' => 'max-width: 300px;'],
            ],
            [
                'attribute' => 'created_at',
                'format' => 'datetime',
            ],
        ],
    ]); ?>
</div>