<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;

$this->title = 'Редактирование заявки #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Управление заявками', 'url' => ['bookings']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-update-booking">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title"><?= Html::encode($this->title) ?></h2>
        </div>
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-6">
                    <h5>Информация о заявке</h5>
                    <p><strong>Пользователь:</strong> <?= Html::encode($model->user->full_name) ?></p>
                    <p><strong>Тип номера:</strong> <?= Html::encode($model->roomType->name) ?></p>
                    <p><strong>Даты:</strong> <?= Yii::$app->formatter->asDate($model->check_in_date) ?> - <?= Yii::$app->formatter->asDate($model->check_out_date) ?></p>
                </div>
                <div class="col-md-6">
                    <h5>Детали бронирования</h5>
                    <p><strong>Взрослые:</strong> <?= $model->adults_count ?></p>
                    <p><strong>Дети:</strong> <?= $model->children_count ?></p>
                    <p><strong>Сумма:</strong> <?= Yii::$app->formatter->asCurrency($model->total_amount) ?></p>
                </div>
            </div>

            <?php $form = ActiveForm::begin(); ?>

            <?= $form->field($model, 'status')->dropDownList(\app\models\Booking::getStatusLabels()) ?>

            <div class="form-group">
                <?= Html::submitButton('Сохранить изменения', ['class' => 'btn btn-success']) ?>
                <?= Html::a('Отмена', ['bookings'], ['class' => 'btn btn-secondary']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>