<?php
use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;

$this->title = 'Редактирование типа номера: ' . $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Типы номеров', 'url' => ['room-types']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-update-room-type">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title"><?= Html::encode($this->title) ?></h2>
        </div>
        <div class="card-body">
            <?php $form = ActiveForm::begin(); ?>

            <?= $form->field($model, 'name')->textInput() ?>
            <?= $form->field($model, 'description')->textarea(['rows' => 4]) ?>
            <?= $form->field($model, 'price_per_night')->textInput(['type' => 'number', 'step' => '0.01']) ?>
            <?= $form->field($model, 'max_guests')->textInput(['type' => 'number']) ?>
            <?= $form->field($model, 'bed_type')->textInput() ?>

            <div class="form-group">
                <?= Html::submitButton('Сохранить изменения', ['class' => 'btn btn-success']) ?>
                <?= Html::a('Отмена', ['room-types'], ['class' => 'btn btn-secondary']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>