<?php
use yii\helpers\Html;

$this->title = 'Мои заявки';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="booking-index">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
        <?= Html::a('Новая заявка', ['create'], ['class' => 'btn btn-success']) ?>
    </div>

    <?php if (empty($bookings)): ?>
        <div class="alert alert-info">
            У вас пока нет заявок на бронирование.
        </div>
    <?php else: ?>
        <div class="row">
            <?php foreach ($bookings as $booking): ?>
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Заявка #<?= $booking->id ?></h5>
                            <span class="badge bg-<?= $booking->status === 'new' ? 'primary' : ($booking->status === 'completed' ? 'success' : 'warning') ?>">
                            <?= $booking->getStatusLabel() ?>
                        </span>
                        </div>
                        <div class="card-body">
                            <p><strong>Тип номера:</strong> <?= Html::encode($booking->roomType->name) ?></p>
                            <p><strong>Даты:</strong> <?= Yii::$app->formatter->asDate($booking->check_in_date) ?> - <?= Yii::$app->formatter->asDate($booking->check_out_date) ?></p>
                            <p><strong>Гости:</strong> <?= $booking->adults_count ?> взрослых, <?= $booking->children_count ?> детей</p>
                            <p><strong>Сумма:</strong> <?= Yii::$app->formatter->asCurrency($booking->total_amount) ?></p>
                            <p><strong>Создана:</strong> <?= Yii::$app->formatter->asDatetime($booking->created_at) ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>