<?php
// views/site/index.php
use yii\helpers\Url;
?>
<div class="site-index">
    <section class="hero-section bg-primary text-white text-center py-5">
        <div class="container">
            <h1 class="display-4">Добро пожаловать в отель "Как дома"</h1>
            <p class="lead">Комфорт и уют в самом сердце города</p>
            <a href="<?= Url::to(['/site/rooms']) ?>" class="btn btn-light btn-lg">Посмотреть номера</a>
        </div>
    </section>

    <!-- О отеле -->
    <section class="about-section py-5">
        <div class="container">
            <h2 class="text-center mb-5">Об отеле</h2>
            <div class="row">
                <div class="col-md-6">
                    <p>Отель "Как дома" предлагает комфортабельные номера для вашего идеального отдыха.</p>
                    <ul>
                        <li>Удобное расположение в центре города</li>
                        <li>Современные номера с качественным ремонтом</li>
                        <li>Круглосуточное обслуживание</li>
                        <li>Бесплатный Wi-Fi</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <img src="/images/hotel.jpg" class="img-fluid rounded" alt="Отель">
                </div>
            </div>
        </div>
    </section>

    <section class="features-section bg-light py-5">
        <div class="container">
            <h2 class="text-center mb-5">Наши преимущества</h2>
            <div class="row">
                <div class="col-md-4 text-center">
                    <i class="fas fa-map-marker-alt fa-3x text-primary mb-3"></i>
                    <h5>Удобное расположение</h5>
                    <p>В центре города, рядом с основными достопримечательностями</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fas fa-wifi fa-3x text-primary mb-3"></i>
                    <h5>Бесплатный Wi-Fi</h5>
                    <p>Высокоскоростной интернет на всей территории отеля</p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fas fa-concierge-bell fa-3x text-primary mb-3"></i>
                    <h5>Круглосуточный сервис</h5>
                    <p>Всегда готовы помочь вам 24/7</p>
                </div>
            </div>
        </div>
    </section>
</div>