<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Номера и цены';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-rooms">
    <!-- Hero Section -->
    <section class="hero-section bg-light py-5 mb-5">
        <div class="container">
            <h1 class="display-4 text-center">Наши номера</h1>
            <p class="lead text-center">Выберите идеальный номер для вашего отдыха</p>
        </div>
    </section>

    <div class="container">
        <div class="row">
            <?php foreach ($roomTypes as $index => $roomType): ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card room-card h-100">
                        <div class="card-img-wrapper">
                            <img src="/images/rooms/room-<?= $roomType->id ?>.jpg"
                                 class="card-img-top"
                                 alt="<?= Html::encode($roomType->name) ?>"
                                 style="height: 200px; object-fit: cover;"
                                 onerror="this.src='https://via.placeholder.com/300x200?text=Номер+<?= $roomType->id ?>'">
                        </div>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title"><?= Html::encode($roomType->name) ?></h5>
                            <p class="card-text flex-grow-1"><?= Html::encode($roomType->description) ?></p>

                            <div class="room-features mb-3">
                                <div class="d-flex justify-content-between text-muted small">
                                    <span><i class="fas fa-user-friends"></i> До <?= $roomType->max_guests ?> гостей</span>
                                    <span><i class="fas fa-bed"></i> <?= Html::encode($roomType->bed_type) ?></span>
                                </div>
                            </div>

                            <div class="mt-auto">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="h4 text-primary mb-0"><?= Yii::$app->formatter->asCurrency($roomType->price_per_night) ?></span>
                                    <small class="text-muted">за ночь</small>
                                </div>

                                <?php if (!Yii::$app->user->isGuest): ?>
                                    <?= Html::a('<i class="fas fa-calendar-check"></i> Забронировать',
                                        ['booking/create', 'room_type_id' => $roomType->id], [
                                            'class' => 'btn btn-primary btn-block btn-lg'
                                        ]) ?>
                                <?php else: ?>
                                    <?= Html::a('<i class="fas fa-sign-in-alt"></i> Войти для бронирования',
                                        ['site/login'], [
                                            'class' => 'btn btn-outline-primary btn-block'
                                        ]) ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Дополнительная информация -->
        <div class="row mt-5">
            <div class="col-12">
                <div class="card bg-dark text-white">
                    <div class="card-body text-center py-5">
                        <h3 class="card-title">Не нашли подходящий номер?</h3>
                        <p class="card-text">Свяжитесь с нами, и мы поможем подобрать оптимальный вариант</p>
                        <div class="mt-4">
                            <a href="tel:+74951234567" class="btn btn-light btn-lg me-3">
                                <i class="fas fa-phone"></i> +7 (495) 123-45-67
                            </a>
                            <a href="mailto:info@kakdoma.ru" class="btn btn-outline-light btn-lg">
                                <i class="fas fa-envelope"></i> info@kakdoma.ru
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>